/*
 * Decompiled with CFR 0.152.
 */
package Main;

import GameState.GameStateManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements Runnable,
KeyListener {
    public static final int WIDTH = 320;
    public static final int HEIGHT = 240;
    public static final int SCALE = 3;
    private Thread thread;
    private boolean running;
    private int FPS = 60;
    private long targetTime = 1000 / this.FPS;
    private BufferedImage image;
    private Graphics2D graphics;
    private GameStateManager gsm;

    public GamePanel() {
        this.setPreferredSize(new Dimension(960, 720));
        this.setFocusable(true);
        this.requestFocus();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.addKeyListener(this);
            this.thread.start();
        }
    }

    private void init() {
        this.image = new BufferedImage(320, 240, 1);
        this.graphics = (Graphics2D)this.image.getGraphics();
        this.running = true;
        this.gsm = new GameStateManager();
    }

    @Override
    public void run() {
        this.init();
        while (this.running) {
            long start = System.nanoTime();
            this.update();
            this.draw();
            this.drawToScreen();
            long elapsed = System.nanoTime() - start;
            long wait = this.targetTime - elapsed / 1000000L;
            if (wait < 0L) {
                wait = 5L;
            }
            try {
                Thread.sleep(wait);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void update() {
        this.gsm.update();
    }

    private void draw() {
        this.gsm.draw(this.graphics);
    }

    private void drawToScreen() {
        Graphics graphics2 = this.getGraphics();
        graphics2.drawImage(this.image, 0, 0, 960, 720, null);
        graphics2.dispose();
    }

    @Override
    public void keyTyped(KeyEvent key) {
    }

    @Override
    public void keyPressed(KeyEvent key) {
        this.gsm.keyPressed(key.getKeyCode());
    }

    @Override
    public void keyReleased(KeyEvent key) {
        this.gsm.keyReleased(key.getKeyCode());
    }
}

